package io.k8s.api.batch.v1


/** PodFailurePolicy describes how failed pods influence the backoffLimit. */
final case class PodFailurePolicy(
  rules : Seq[io.k8s.api.batch.v1.PodFailurePolicyRule]
) {

  /** Returns a new data with rules set to new value */
  def withRules(value: Seq[io.k8s.api.batch.v1.PodFailurePolicyRule]) : PodFailurePolicy = copy(rules = value)
  /** Appends new values to rules */
  def addRules(newValues: io.k8s.api.batch.v1.PodFailurePolicyRule*) : PodFailurePolicy = copy(rules = rules ++ newValues)
  /** transforms rules to result of function */
  def mapRules(f: Seq[io.k8s.api.batch.v1.PodFailurePolicyRule] => Seq[io.k8s.api.batch.v1.PodFailurePolicyRule]) : PodFailurePolicy = copy(rules = f(rules))
}

