package io.k8s.api.autoscaling.v2


/** ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object). */
final case class ObjectMetricSource(
  describedObject : io.k8s.api.autoscaling.v2.CrossVersionObjectReference,
  metric : io.k8s.api.autoscaling.v2.MetricIdentifier,
  target : io.k8s.api.autoscaling.v2.MetricTarget
) {

  /** Returns a new data with describedObject set to new value */
  def withDescribedObject(value: io.k8s.api.autoscaling.v2.CrossVersionObjectReference) : ObjectMetricSource = copy(describedObject = value)
  /** transforms describedObject to result of function */
  def mapDescribedObject(f: io.k8s.api.autoscaling.v2.CrossVersionObjectReference => io.k8s.api.autoscaling.v2.CrossVersionObjectReference) : ObjectMetricSource = copy(describedObject = f(describedObject))

  /** Returns a new data with metric set to new value */
  def withMetric(value: io.k8s.api.autoscaling.v2.MetricIdentifier) : ObjectMetricSource = copy(metric = value)
  /** transforms metric to result of function */
  def mapMetric(f: io.k8s.api.autoscaling.v2.MetricIdentifier => io.k8s.api.autoscaling.v2.MetricIdentifier) : ObjectMetricSource = copy(metric = f(metric))

  /** Returns a new data with target set to new value */
  def withTarget(value: io.k8s.api.autoscaling.v2.MetricTarget) : ObjectMetricSource = copy(target = value)
  /** transforms target to result of function */
  def mapTarget(f: io.k8s.api.autoscaling.v2.MetricTarget => io.k8s.api.autoscaling.v2.MetricTarget) : ObjectMetricSource = copy(target = f(target))
}

