package io.k8s.api.authorization.v1


/** SubjectAccessReviewSpec is a description of the access request.  Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set */
final case class SubjectAccessReviewSpec(
  groups : Option[Seq[String]] = None,
  resourceAttributes : Option[io.k8s.api.authorization.v1.ResourceAttributes] = None,
  uid : Option[String] = None,
  extra : Option[Map[String, Seq[String]]] = None,
  user : Option[String] = None,
  nonResourceAttributes : Option[io.k8s.api.authorization.v1.NonResourceAttributes] = None
) {

  /** Returns a new data with groups set to new value */
  def withGroups(value: Seq[String]) : SubjectAccessReviewSpec = copy(groups = Some(value))
  /** Appends new values to groups */
  def addGroups(newValues: String*) : SubjectAccessReviewSpec = copy(groups = Some(groups.fold(newValues)(_ ++ newValues)))
  /** if groups has a value, transforms to the result of function*/
  def mapGroups(f: Seq[String] => Seq[String]) : SubjectAccessReviewSpec = copy(groups = groups.map(f))

  /** Returns a new data with resourceAttributes set to new value */
  def withResourceAttributes(value: io.k8s.api.authorization.v1.ResourceAttributes) : SubjectAccessReviewSpec = copy(resourceAttributes = Some(value))
  /** if resourceAttributes has a value, transforms to the result of function*/
  def mapResourceAttributes(f: io.k8s.api.authorization.v1.ResourceAttributes => io.k8s.api.authorization.v1.ResourceAttributes) : SubjectAccessReviewSpec = copy(resourceAttributes = resourceAttributes.map(f))

  /** Returns a new data with uid set to new value */
  def withUid(value: String) : SubjectAccessReviewSpec = copy(uid = Some(value))
  /** if uid has a value, transforms to the result of function*/
  def mapUid(f: String => String) : SubjectAccessReviewSpec = copy(uid = uid.map(f))

  /** Returns a new data with extra set to new value */
  def withExtra(value: Map[String, Seq[String]]) : SubjectAccessReviewSpec = copy(extra = Some(value))
  /** Adds new values to extra */
  def addExtra(newValues: (String, Seq[String])*) : SubjectAccessReviewSpec = copy(extra = Some(extra.fold(newValues.toMap)(_ ++ newValues)))
  /** if extra has a value, transforms to the result of function*/
  def mapExtra(f: Map[String, Seq[String]] => Map[String, Seq[String]]) : SubjectAccessReviewSpec = copy(extra = extra.map(f))

  /** Returns a new data with user set to new value */
  def withUser(value: String) : SubjectAccessReviewSpec = copy(user = Some(value))
  /** if user has a value, transforms to the result of function*/
  def mapUser(f: String => String) : SubjectAccessReviewSpec = copy(user = user.map(f))

  /** Returns a new data with nonResourceAttributes set to new value */
  def withNonResourceAttributes(value: io.k8s.api.authorization.v1.NonResourceAttributes) : SubjectAccessReviewSpec = copy(nonResourceAttributes = Some(value))
  /** if nonResourceAttributes has a value, transforms to the result of function*/
  def mapNonResourceAttributes(f: io.k8s.api.authorization.v1.NonResourceAttributes => io.k8s.api.authorization.v1.NonResourceAttributes) : SubjectAccessReviewSpec = copy(nonResourceAttributes = nonResourceAttributes.map(f))
}

