package io.k8s.api.authentication.v1


/** TokenReviewSpec is a description of the token authentication request. */
final case class TokenReviewSpec(
  audiences : Option[Seq[String]] = None,
  token : Option[String] = None
) {

  /** Returns a new data with audiences set to new value */
  def withAudiences(value: Seq[String]) : TokenReviewSpec = copy(audiences = Some(value))
  /** Appends new values to audiences */
  def addAudiences(newValues: String*) : TokenReviewSpec = copy(audiences = Some(audiences.fold(newValues)(_ ++ newValues)))
  /** if audiences has a value, transforms to the result of function*/
  def mapAudiences(f: Seq[String] => Seq[String]) : TokenReviewSpec = copy(audiences = audiences.map(f))

  /** Returns a new data with token set to new value */
  def withToken(value: String) : TokenReviewSpec = copy(token = Some(value))
  /** if token has a value, transforms to the result of function*/
  def mapToken(f: String => String) : TokenReviewSpec = copy(token = token.map(f))
}

