package io.k8s.api.apps.v1

import dev.hnaderi.k8s._

/** Deployment enables declarative updates for Pods and ReplicaSets. */
final case class Deployment(
  status : Option[io.k8s.api.apps.v1.DeploymentStatus] = None,
  spec : Option[io.k8s.api.apps.v1.DeploymentSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apps", "Deployment", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.apps.v1.DeploymentStatus) : Deployment = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.apps.v1.DeploymentStatus => io.k8s.api.apps.v1.DeploymentStatus) : Deployment = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.apps.v1.DeploymentSpec) : Deployment = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.apps.v1.DeploymentSpec => io.k8s.api.apps.v1.DeploymentSpec) : Deployment = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Deployment = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Deployment = copy(metadata = metadata.map(f))
}

