package io.k8s.api.flowcontrol.v1beta1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** FlowSchema defines the schema of a group of flows. Note that a flow is made up of a set of inbound API requests with similar attributes and is identified by a pair of strings: the name of the FlowSchema and a "flow distinguisher". */
final case class FlowSchema(
  status : Option[io.k8s.api.flowcontrol.v1beta1.FlowSchemaStatus] = None,
  spec : Option[io.k8s.api.flowcontrol.v1beta1.FlowSchemaSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("flowcontrol.apiserver.k8s.io", "FlowSchema", "v1beta1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.flowcontrol.v1beta1.FlowSchemaStatus) : FlowSchema = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.flowcontrol.v1beta1.FlowSchemaStatus => io.k8s.api.flowcontrol.v1beta1.FlowSchemaStatus) : FlowSchema = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.flowcontrol.v1beta1.FlowSchemaSpec) : FlowSchema = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.flowcontrol.v1beta1.FlowSchemaSpec => io.k8s.api.flowcontrol.v1beta1.FlowSchemaSpec) : FlowSchema = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : FlowSchema = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : FlowSchema = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = FlowSchema.encoder.apply(this)
}

object FlowSchema {

    implicit val encoder : Encoder[io.k8s.api.flowcontrol.v1beta1.FlowSchema] = new Encoder[io.k8s.api.flowcontrol.v1beta1.FlowSchema] {
        def apply[T : Builder](o: io.k8s.api.flowcontrol.v1beta1.FlowSchema) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[FlowSchema] = new Decoder[FlowSchema] {
      def apply[T : Reader](t: T): Either[String, FlowSchema] = for {
          obj <- ObjectReader(t)
          status <- obj.readOpt[io.k8s.api.flowcontrol.v1beta1.FlowSchemaStatus]("status")
          spec <- obj.readOpt[io.k8s.api.flowcontrol.v1beta1.FlowSchemaSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield FlowSchema (
          status = status,
          spec = spec,
          metadata = metadata
        )
    }
}

