package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** DeleteOptions may be provided when deleting an API object. */

final case class DeleteOptions(
  kind: String,
  apiVersion: String,
  orphanDependents : Option[Boolean] = None,
  preconditions : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Preconditions] = None,
  propagationPolicy : Option[String] = None,
  gracePeriodSeconds : Option[Long] = None,
  dryRun : Option[Seq[String]] = None
)

object DeleteOptions {
  val knownKinds : Seq[ResourceKind] = Seq(
    ResourceKind("", "DeleteOptions", "v1"),
    ResourceKind("admission.k8s.io", "DeleteOptions", "v1"),
    ResourceKind("admission.k8s.io", "DeleteOptions", "v1beta1"),
    ResourceKind("admissionregistration.k8s.io", "DeleteOptions", "v1"),
    ResourceKind("admissionregistration.k8s.io", "DeleteOptions", "v1alpha1"),
    ResourceKind("admissionregistration.k8s.io", "DeleteOptions", "v1beta1"),
    ResourceKind("apiextensions.k8s.io", "DeleteOptions", "v1"),
    ResourceKind("apiextensions.k8s.io", "DeleteOptions", "v1beta1"),
    ResourceKind("apiregistration.k8s.io", "DeleteOptions", "v1"),
    ResourceKind("apiregistration.k8s.io", "DeleteOptions", "v1beta1"),
    ResourceKind("apps", "DeleteOptions", "v1"),
    ResourceKind("apps", "DeleteOptions", "v1beta1"),
    ResourceKind("apps", "DeleteOptions", "v1beta2"),
    ResourceKind("authentication.k8s.io", "DeleteOptions", "v1"),
    ResourceKind("authentication.k8s.io", "DeleteOptions", "v1alpha1"),
    ResourceKind("authentication.k8s.io", "DeleteOptions", "v1beta1"),
    ResourceKind("authorization.k8s.io", "DeleteOptions", "v1"),
    ResourceKind("authorization.k8s.io", "DeleteOptions", "v1beta1"),
    ResourceKind("autoscaling", "DeleteOptions", "v1"),
    ResourceKind("autoscaling", "DeleteOptions", "v2"),
    ResourceKind("autoscaling", "DeleteOptions", "v2beta1"),
    ResourceKind("autoscaling", "DeleteOptions", "v2beta2"),
    ResourceKind("batch", "DeleteOptions", "v1"),
    ResourceKind("batch", "DeleteOptions", "v1beta1"),
    ResourceKind("certificates.k8s.io", "DeleteOptions", "v1"),
    ResourceKind("certificates.k8s.io", "DeleteOptions", "v1alpha1"),
    ResourceKind("certificates.k8s.io", "DeleteOptions", "v1beta1"),
    ResourceKind("coordination.k8s.io", "DeleteOptions", "v1"),
    ResourceKind("coordination.k8s.io", "DeleteOptions", "v1beta1"),
    ResourceKind("discovery.k8s.io", "DeleteOptions", "v1"),
    ResourceKind("discovery.k8s.io", "DeleteOptions", "v1beta1"),
    ResourceKind("events.k8s.io", "DeleteOptions", "v1"),
    ResourceKind("events.k8s.io", "DeleteOptions", "v1beta1"),
    ResourceKind("extensions", "DeleteOptions", "v1beta1"),
    ResourceKind("flowcontrol.apiserver.k8s.io", "DeleteOptions", "v1"),
    ResourceKind("flowcontrol.apiserver.k8s.io", "DeleteOptions", "v1beta1"),
    ResourceKind("flowcontrol.apiserver.k8s.io", "DeleteOptions", "v1beta2"),
    ResourceKind("flowcontrol.apiserver.k8s.io", "DeleteOptions", "v1beta3"),
    ResourceKind("imagepolicy.k8s.io", "DeleteOptions", "v1alpha1"),
    ResourceKind("internal.apiserver.k8s.io", "DeleteOptions", "v1alpha1"),
    ResourceKind("networking.k8s.io", "DeleteOptions", "v1"),
    ResourceKind("networking.k8s.io", "DeleteOptions", "v1alpha1"),
    ResourceKind("networking.k8s.io", "DeleteOptions", "v1beta1"),
    ResourceKind("node.k8s.io", "DeleteOptions", "v1"),
    ResourceKind("node.k8s.io", "DeleteOptions", "v1alpha1"),
    ResourceKind("node.k8s.io", "DeleteOptions", "v1beta1"),
    ResourceKind("policy", "DeleteOptions", "v1"),
    ResourceKind("policy", "DeleteOptions", "v1beta1"),
    ResourceKind("rbac.authorization.k8s.io", "DeleteOptions", "v1"),
    ResourceKind("rbac.authorization.k8s.io", "DeleteOptions", "v1alpha1"),
    ResourceKind("rbac.authorization.k8s.io", "DeleteOptions", "v1beta1"),
    ResourceKind("resource.k8s.io", "DeleteOptions", "v1alpha2"),
    ResourceKind("scheduling.k8s.io", "DeleteOptions", "v1"),
    ResourceKind("scheduling.k8s.io", "DeleteOptions", "v1alpha1"),
    ResourceKind("scheduling.k8s.io", "DeleteOptions", "v1beta1"),
    ResourceKind("storage.k8s.io", "DeleteOptions", "v1"),
    ResourceKind("storage.k8s.io", "DeleteOptions", "v1alpha1"),
    ResourceKind("storage.k8s.io", "DeleteOptions", "v1beta1")
  )


    implicit val encoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions] = new Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions] {
        def apply[T : Builder](o: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("orphanDependents", o.orphanDependents)
            .write("preconditions", o.preconditions)
            .write("propagationPolicy", o.propagationPolicy)
            .write("gracePeriodSeconds", o.gracePeriodSeconds)
            .write("dryRun", o.dryRun)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[DeleteOptions] = new Decoder[DeleteOptions] {
      def apply[T : Reader](t: T): Either[String, DeleteOptions] = for {
          obj <- ObjectReader(t)
          apiVersion <- obj.read[String]("apiVersion")
          kind <- obj.read[String]("kind")
          orphanDependents <- obj.readOpt[Boolean]("orphanDependents")
          preconditions <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.Preconditions]("preconditions")
          propagationPolicy <- obj.readOpt[String]("propagationPolicy")
          gracePeriodSeconds <- obj.readOpt[Long]("gracePeriodSeconds")
          dryRun <- obj.readOpt[Seq[String]]("dryRun")
      } yield DeleteOptions (
          orphanDependents = orphanDependents,
          preconditions = preconditions,
          propagationPolicy = propagationPolicy,
          gracePeriodSeconds = gracePeriodSeconds,
          dryRun = dryRun,
          apiVersion = apiVersion,
          kind = kind
        )
    }
}

