package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1

import dev.hnaderi.k8s.utils._

/** ValidationRule describes a validation rule written in the CEL expression language. */
final case class ValidationRule(
  rule : String,
  fieldPath : Option[String] = None,
  reason : Option[String] = None,
  messageExpression : Option[String] = None,
  message : Option[String] = None,
  optionalOldSelf : Option[Boolean] = None
) {

  /** Returns a new data with rule set to new value */
  def withRule(value: String) : ValidationRule = copy(rule = value)
  /** transforms rule to result of function */
  def mapRule(f: String => String) : ValidationRule = copy(rule = f(rule))

  /** Returns a new data with fieldPath set to new value */
  def withFieldPath(value: String) : ValidationRule = copy(fieldPath = Some(value))
  /** if fieldPath has a value, transforms to the result of function*/
  def mapFieldPath(f: String => String) : ValidationRule = copy(fieldPath = fieldPath.map(f))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : ValidationRule = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : ValidationRule = copy(reason = reason.map(f))

  /** Returns a new data with messageExpression set to new value */
  def withMessageExpression(value: String) : ValidationRule = copy(messageExpression = Some(value))
  /** if messageExpression has a value, transforms to the result of function*/
  def mapMessageExpression(f: String => String) : ValidationRule = copy(messageExpression = messageExpression.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : ValidationRule = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : ValidationRule = copy(message = message.map(f))

  /** Returns a new data with optionalOldSelf set to new value */
  def withOptionalOldSelf(value: Boolean) : ValidationRule = copy(optionalOldSelf = Some(value))
  /** if optionalOldSelf has a value, transforms to the result of function*/
  def mapOptionalOldSelf(f: Boolean => Boolean) : ValidationRule = copy(optionalOldSelf = optionalOldSelf.map(f))
}

object ValidationRule {

    implicit val encoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule] = new Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule] {
        def apply[T : Builder](o: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("rule", o.rule)
            .write("fieldPath", o.fieldPath)
            .write("reason", o.reason)
            .write("messageExpression", o.messageExpression)
            .write("message", o.message)
            .write("optionalOldSelf", o.optionalOldSelf)
            .build
        }
    }

    implicit val decoder: Decoder[ValidationRule] = new Decoder[ValidationRule] {
      def apply[T : Reader](t: T): Either[String, ValidationRule] = for {
          obj <- ObjectReader(t)
          rule <- obj.read[String]("rule")
          fieldPath <- obj.readOpt[String]("fieldPath")
          reason <- obj.readOpt[String]("reason")
          messageExpression <- obj.readOpt[String]("messageExpression")
          message <- obj.readOpt[String]("message")
          optionalOldSelf <- obj.readOpt[Boolean]("optionalOldSelf")
      } yield ValidationRule (
          rule = rule,
          fieldPath = fieldPath,
          reason = reason,
          messageExpression = messageExpression,
          message = message,
          optionalOldSelf = optionalOldSelf
        )
    }
}

