package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s.utils._

/** PodSchedulingContextStatus describes where resources for the Pod can be allocated. */
final case class PodSchedulingContextStatus(
  resourceClaims : Option[Seq[io.k8s.api.resource.v1alpha2.ResourceClaimSchedulingStatus]] = None
) {

  /** Returns a new data with resourceClaims set to new value */
  def withResourceClaims(value: Seq[io.k8s.api.resource.v1alpha2.ResourceClaimSchedulingStatus]) : PodSchedulingContextStatus = copy(resourceClaims = Some(value))
  /** Appends new values to resourceClaims */
  def addResourceClaims(newValues: io.k8s.api.resource.v1alpha2.ResourceClaimSchedulingStatus*) : PodSchedulingContextStatus = copy(resourceClaims = Some(resourceClaims.fold(newValues)(_ ++ newValues)))
  /** if resourceClaims has a value, transforms to the result of function*/
  def mapResourceClaims(f: Seq[io.k8s.api.resource.v1alpha2.ResourceClaimSchedulingStatus] => Seq[io.k8s.api.resource.v1alpha2.ResourceClaimSchedulingStatus]) : PodSchedulingContextStatus = copy(resourceClaims = resourceClaims.map(f))
}

object PodSchedulingContextStatus {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.PodSchedulingContextStatus] = new Encoder[io.k8s.api.resource.v1alpha2.PodSchedulingContextStatus] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.PodSchedulingContextStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("resourceClaims", o.resourceClaims)
            .build
        }
    }

    implicit val decoder: Decoder[PodSchedulingContextStatus] = new Decoder[PodSchedulingContextStatus] {
      def apply[T : Reader](t: T): Either[String, PodSchedulingContextStatus] = for {
          obj <- ObjectReader(t)
          resourceClaims <- obj.readOpt[Seq[io.k8s.api.resource.v1alpha2.ResourceClaimSchedulingStatus]]("resourceClaims")
      } yield PodSchedulingContextStatus (
          resourceClaims = resourceClaims
        )
    }
}

