package io.k8s.api.policy.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** Eviction evicts a pod from its node subject to certain policies and safety constraints. This is a subresource of Pod.  A request to cause such an eviction is created by POSTing to .../pods/<pod name>/evictions. */
final case class Eviction(
  deleteOptions : Option[io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("policy", "Eviction", "v1")


  /** Returns a new data with deleteOptions set to new value */
  def withDeleteOptions(value: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions) : Eviction = copy(deleteOptions = Some(value))
  /** if deleteOptions has a value, transforms to the result of function*/
  def mapDeleteOptions(f: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions => io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions) : Eviction = copy(deleteOptions = deleteOptions.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Eviction = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Eviction = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = Eviction.encoder.apply(this)
}

object Eviction {

    implicit val encoder : Encoder[io.k8s.api.policy.v1.Eviction] = new Encoder[io.k8s.api.policy.v1.Eviction] {
        def apply[T : Builder](o: io.k8s.api.policy.v1.Eviction) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("deleteOptions", o.deleteOptions)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[Eviction] = new Decoder[Eviction] {
      def apply[T : Reader](t: T): Either[String, Eviction] = for {
          obj <- ObjectReader(t)
          deleteOptions <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions]("deleteOptions")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield Eviction (
          deleteOptions = deleteOptions,
          metadata = metadata
        )
    }
}

