package io.k8s.api.flowcontrol.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** PriorityLevelConfiguration represents the configuration of a priority level. */
final case class PriorityLevelConfiguration(
  status : Option[io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationStatus] = None,
  spec : Option[io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("flowcontrol.apiserver.k8s.io", "PriorityLevelConfiguration", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationStatus) : PriorityLevelConfiguration = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationStatus => io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationStatus) : PriorityLevelConfiguration = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationSpec) : PriorityLevelConfiguration = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationSpec => io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationSpec) : PriorityLevelConfiguration = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PriorityLevelConfiguration = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PriorityLevelConfiguration = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = PriorityLevelConfiguration.encoder.apply(this)
}

object PriorityLevelConfiguration {

    implicit val encoder : Encoder[io.k8s.api.flowcontrol.v1.PriorityLevelConfiguration] = new Encoder[io.k8s.api.flowcontrol.v1.PriorityLevelConfiguration] {
        def apply[T : Builder](o: io.k8s.api.flowcontrol.v1.PriorityLevelConfiguration) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[PriorityLevelConfiguration] = new Decoder[PriorityLevelConfiguration] {
      def apply[T : Reader](t: T): Either[String, PriorityLevelConfiguration] = for {
          obj <- ObjectReader(t)
          status <- obj.readOpt[io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationStatus]("status")
          spec <- obj.readOpt[io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield PriorityLevelConfiguration (
          status = status,
          spec = spec,
          metadata = metadata
        )
    }
}

