package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** PodResourceClaim references exactly one ResourceClaim through a ClaimSource. It adds a name to it that uniquely identifies the ResourceClaim inside the Pod. Containers that need access to the ResourceClaim reference it with this name. */
final case class PodResourceClaim(
  name : String,
  source : Option[io.k8s.api.core.v1.ClaimSource] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : PodResourceClaim = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : PodResourceClaim = copy(name = f(name))

  /** Returns a new data with source set to new value */
  def withSource(value: io.k8s.api.core.v1.ClaimSource) : PodResourceClaim = copy(source = Some(value))
  /** if source has a value, transforms to the result of function*/
  def mapSource(f: io.k8s.api.core.v1.ClaimSource => io.k8s.api.core.v1.ClaimSource) : PodResourceClaim = copy(source = source.map(f))
}

object PodResourceClaim {

    implicit val encoder : Encoder[io.k8s.api.core.v1.PodResourceClaim] = new Encoder[io.k8s.api.core.v1.PodResourceClaim] {
        def apply[T : Builder](o: io.k8s.api.core.v1.PodResourceClaim) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("source", o.source)
            .build
        }
    }

    implicit val decoder: Decoder[PodResourceClaim] = new Decoder[PodResourceClaim] {
      def apply[T : Reader](t: T): Either[String, PodResourceClaim] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
          source <- obj.readOpt[io.k8s.api.core.v1.ClaimSource]("source")
      } yield PodResourceClaim (
          name = name,
          source = source
        )
    }
}

