package io.k8s.api.core.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** PersistentVolumeClaimList is a list of PersistentVolumeClaim items. */
final case class PersistentVolumeClaimList(
  items : Seq[io.k8s.api.core.v1.PersistentVolumeClaim],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "PersistentVolumeClaimList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.core.v1.PersistentVolumeClaim]) : PersistentVolumeClaimList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.core.v1.PersistentVolumeClaim*) : PersistentVolumeClaimList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.core.v1.PersistentVolumeClaim] => Seq[io.k8s.api.core.v1.PersistentVolumeClaim]) : PersistentVolumeClaimList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : PersistentVolumeClaimList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : PersistentVolumeClaimList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = PersistentVolumeClaimList.encoder.apply(this)
}

object PersistentVolumeClaimList {

    implicit val encoder : Encoder[io.k8s.api.core.v1.PersistentVolumeClaimList] = new Encoder[io.k8s.api.core.v1.PersistentVolumeClaimList] {
        def apply[T : Builder](o: io.k8s.api.core.v1.PersistentVolumeClaimList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[PersistentVolumeClaimList] = new Decoder[PersistentVolumeClaimList] {
      def apply[T : Reader](t: T): Either[String, PersistentVolumeClaimList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.core.v1.PersistentVolumeClaim]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield PersistentVolumeClaimList (
          items = items,
          metadata = metadata
        )
    }
}

