package io.k8s.api.coordination.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** LeaseList is a list of Lease objects. */
final case class LeaseList(
  items : Seq[io.k8s.api.coordination.v1.Lease],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("coordination.k8s.io", "LeaseList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.coordination.v1.Lease]) : LeaseList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.coordination.v1.Lease*) : LeaseList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.coordination.v1.Lease] => Seq[io.k8s.api.coordination.v1.Lease]) : LeaseList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : LeaseList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : LeaseList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = LeaseList.encoder.apply(this)
}

object LeaseList {

    implicit val encoder : Encoder[io.k8s.api.coordination.v1.LeaseList] = new Encoder[io.k8s.api.coordination.v1.LeaseList] {
        def apply[T : Builder](o: io.k8s.api.coordination.v1.LeaseList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[LeaseList] = new Decoder[LeaseList] {
      def apply[T : Reader](t: T): Either[String, LeaseList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.coordination.v1.Lease]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield LeaseList (
          items = items,
          metadata = metadata
        )
    }
}

