package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** SecurityContext holds security configuration that will be applied to a container. Some fields are present in both SecurityContext and PodSecurityContext.  When both are set, the values in SecurityContext take precedence. */
final case class SecurityContext(
  capabilities : Option[io.k8s.api.core.v1.Capabilities] = None,
  readOnlyRootFilesystem : Option[Boolean] = None,
  allowPrivilegeEscalation : Option[Boolean] = None,
  procMount : Option[String] = None,
  runAsGroup : Option[Long] = None,
  seccompProfile : Option[io.k8s.api.core.v1.SeccompProfile] = None,
  windowsOptions : Option[io.k8s.api.core.v1.WindowsSecurityContextOptions] = None,
  seLinuxOptions : Option[io.k8s.api.core.v1.SELinuxOptions] = None,
  runAsUser : Option[Long] = None,
  privileged : Option[Boolean] = None,
  runAsNonRoot : Option[Boolean] = None
) {

  /** Returns a new data with capabilities set to new value */
  def withCapabilities(value: io.k8s.api.core.v1.Capabilities) : SecurityContext = copy(capabilities = Some(value))
  /** if capabilities has a value, transforms to the result of function*/
  def mapCapabilities(f: io.k8s.api.core.v1.Capabilities => io.k8s.api.core.v1.Capabilities) : SecurityContext = copy(capabilities = capabilities.map(f))

  /** Returns a new data with readOnlyRootFilesystem set to new value */
  def withReadOnlyRootFilesystem(value: Boolean) : SecurityContext = copy(readOnlyRootFilesystem = Some(value))
  /** if readOnlyRootFilesystem has a value, transforms to the result of function*/
  def mapReadOnlyRootFilesystem(f: Boolean => Boolean) : SecurityContext = copy(readOnlyRootFilesystem = readOnlyRootFilesystem.map(f))

  /** Returns a new data with allowPrivilegeEscalation set to new value */
  def withAllowPrivilegeEscalation(value: Boolean) : SecurityContext = copy(allowPrivilegeEscalation = Some(value))
  /** if allowPrivilegeEscalation has a value, transforms to the result of function*/
  def mapAllowPrivilegeEscalation(f: Boolean => Boolean) : SecurityContext = copy(allowPrivilegeEscalation = allowPrivilegeEscalation.map(f))

  /** Returns a new data with procMount set to new value */
  def withProcMount(value: String) : SecurityContext = copy(procMount = Some(value))
  /** if procMount has a value, transforms to the result of function*/
  def mapProcMount(f: String => String) : SecurityContext = copy(procMount = procMount.map(f))

  /** Returns a new data with runAsGroup set to new value */
  def withRunAsGroup(value: Long) : SecurityContext = copy(runAsGroup = Some(value))
  /** if runAsGroup has a value, transforms to the result of function*/
  def mapRunAsGroup(f: Long => Long) : SecurityContext = copy(runAsGroup = runAsGroup.map(f))

  /** Returns a new data with seccompProfile set to new value */
  def withSeccompProfile(value: io.k8s.api.core.v1.SeccompProfile) : SecurityContext = copy(seccompProfile = Some(value))
  /** if seccompProfile has a value, transforms to the result of function*/
  def mapSeccompProfile(f: io.k8s.api.core.v1.SeccompProfile => io.k8s.api.core.v1.SeccompProfile) : SecurityContext = copy(seccompProfile = seccompProfile.map(f))

  /** Returns a new data with windowsOptions set to new value */
  def withWindowsOptions(value: io.k8s.api.core.v1.WindowsSecurityContextOptions) : SecurityContext = copy(windowsOptions = Some(value))
  /** if windowsOptions has a value, transforms to the result of function*/
  def mapWindowsOptions(f: io.k8s.api.core.v1.WindowsSecurityContextOptions => io.k8s.api.core.v1.WindowsSecurityContextOptions) : SecurityContext = copy(windowsOptions = windowsOptions.map(f))

  /** Returns a new data with seLinuxOptions set to new value */
  def withSeLinuxOptions(value: io.k8s.api.core.v1.SELinuxOptions) : SecurityContext = copy(seLinuxOptions = Some(value))
  /** if seLinuxOptions has a value, transforms to the result of function*/
  def mapSeLinuxOptions(f: io.k8s.api.core.v1.SELinuxOptions => io.k8s.api.core.v1.SELinuxOptions) : SecurityContext = copy(seLinuxOptions = seLinuxOptions.map(f))

  /** Returns a new data with runAsUser set to new value */
  def withRunAsUser(value: Long) : SecurityContext = copy(runAsUser = Some(value))
  /** if runAsUser has a value, transforms to the result of function*/
  def mapRunAsUser(f: Long => Long) : SecurityContext = copy(runAsUser = runAsUser.map(f))

  /** Returns a new data with privileged set to new value */
  def withPrivileged(value: Boolean) : SecurityContext = copy(privileged = Some(value))
  /** if privileged has a value, transforms to the result of function*/
  def mapPrivileged(f: Boolean => Boolean) : SecurityContext = copy(privileged = privileged.map(f))

  /** Returns a new data with runAsNonRoot set to new value */
  def withRunAsNonRoot(value: Boolean) : SecurityContext = copy(runAsNonRoot = Some(value))
  /** if runAsNonRoot has a value, transforms to the result of function*/
  def mapRunAsNonRoot(f: Boolean => Boolean) : SecurityContext = copy(runAsNonRoot = runAsNonRoot.map(f))
}

object SecurityContext {

    implicit val encoder : Encoder[io.k8s.api.core.v1.SecurityContext] = new Encoder[io.k8s.api.core.v1.SecurityContext] {
        def apply[T : Builder](o: io.k8s.api.core.v1.SecurityContext) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("capabilities", o.capabilities)
            .write("readOnlyRootFilesystem", o.readOnlyRootFilesystem)
            .write("allowPrivilegeEscalation", o.allowPrivilegeEscalation)
            .write("procMount", o.procMount)
            .write("runAsGroup", o.runAsGroup)
            .write("seccompProfile", o.seccompProfile)
            .write("windowsOptions", o.windowsOptions)
            .write("seLinuxOptions", o.seLinuxOptions)
            .write("runAsUser", o.runAsUser)
            .write("privileged", o.privileged)
            .write("runAsNonRoot", o.runAsNonRoot)
            .build
        }
    }

    implicit val decoder: Decoder[SecurityContext] = new Decoder[SecurityContext] {
      def apply[T : Reader](t: T): Either[String, SecurityContext] = for {
          obj <- ObjectReader(t)
          capabilities <- obj.readOpt[io.k8s.api.core.v1.Capabilities]("capabilities")
          readOnlyRootFilesystem <- obj.readOpt[Boolean]("readOnlyRootFilesystem")
          allowPrivilegeEscalation <- obj.readOpt[Boolean]("allowPrivilegeEscalation")
          procMount <- obj.readOpt[String]("procMount")
          runAsGroup <- obj.readOpt[Long]("runAsGroup")
          seccompProfile <- obj.readOpt[io.k8s.api.core.v1.SeccompProfile]("seccompProfile")
          windowsOptions <- obj.readOpt[io.k8s.api.core.v1.WindowsSecurityContextOptions]("windowsOptions")
          seLinuxOptions <- obj.readOpt[io.k8s.api.core.v1.SELinuxOptions]("seLinuxOptions")
          runAsUser <- obj.readOpt[Long]("runAsUser")
          privileged <- obj.readOpt[Boolean]("privileged")
          runAsNonRoot <- obj.readOpt[Boolean]("runAsNonRoot")
      } yield SecurityContext (
          capabilities = capabilities,
          readOnlyRootFilesystem = readOnlyRootFilesystem,
          allowPrivilegeEscalation = allowPrivilegeEscalation,
          procMount = procMount,
          runAsGroup = runAsGroup,
          seccompProfile = seccompProfile,
          windowsOptions = windowsOptions,
          seLinuxOptions = seLinuxOptions,
          runAsUser = runAsUser,
          privileged = privileged,
          runAsNonRoot = runAsNonRoot
        )
    }
}

