package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** PodSchedulingGate is associated to a Pod to guard its scheduling. */
final case class PodSchedulingGate(
  name : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : PodSchedulingGate = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : PodSchedulingGate = copy(name = f(name))
}

object PodSchedulingGate {

    implicit val encoder : Encoder[io.k8s.api.core.v1.PodSchedulingGate] = new Encoder[io.k8s.api.core.v1.PodSchedulingGate] {
        def apply[T : Builder](o: io.k8s.api.core.v1.PodSchedulingGate) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .build
        }
    }

    implicit val decoder: Decoder[PodSchedulingGate] = new Decoder[PodSchedulingGate] {
      def apply[T : Reader](t: T): Either[String, PodSchedulingGate] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
      } yield PodSchedulingGate (
          name = name
        )
    }
}

