package io.k8s.api.admissionregistration.v1alpha1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ValidatingAdmissionPolicyBindingList is a list of ValidatingAdmissionPolicyBinding. */
final case class ValidatingAdmissionPolicyBindingList(
  items : Option[Seq[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyBinding]] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("admissionregistration.k8s.io", "ValidatingAdmissionPolicyBindingList", "v1alpha1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyBinding]) : ValidatingAdmissionPolicyBindingList = copy(items = Some(value))
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyBinding*) : ValidatingAdmissionPolicyBindingList = copy(items = Some(items.fold(newValues)(_ ++ newValues)))
  /** if items has a value, transforms to the result of function*/
  def mapItems(f: Seq[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyBinding] => Seq[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyBinding]) : ValidatingAdmissionPolicyBindingList = copy(items = items.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ValidatingAdmissionPolicyBindingList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ValidatingAdmissionPolicyBindingList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ValidatingAdmissionPolicyBindingList.encoder.apply(this)
}

object ValidatingAdmissionPolicyBindingList {

    implicit val encoder : Encoder[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyBindingList] = new Encoder[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyBindingList] {
        def apply[T : Builder](o: io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyBindingList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ValidatingAdmissionPolicyBindingList] = new Decoder[ValidatingAdmissionPolicyBindingList] {
      def apply[T : Reader](t: T): Either[String, ValidatingAdmissionPolicyBindingList] = for {
          obj <- ObjectReader(t)
          items <- obj.readOpt[Seq[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyBinding]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield ValidatingAdmissionPolicyBindingList (
          items = items,
          metadata = metadata
        )
    }
}

