package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s.utils._

/** AllocationResult contains attributes of an allocated resource. */
final case class AllocationResult(
  availableOnNodes : Option[io.k8s.api.core.v1.NodeSelector] = None,
  resourceHandles : Option[Seq[io.k8s.api.resource.v1alpha2.ResourceHandle]] = None,
  shareable : Option[Boolean] = None
) {

  /** Returns a new data with availableOnNodes set to new value */
  def withAvailableOnNodes(value: io.k8s.api.core.v1.NodeSelector) : AllocationResult = copy(availableOnNodes = Some(value))
  /** if availableOnNodes has a value, transforms to the result of function*/
  def mapAvailableOnNodes(f: io.k8s.api.core.v1.NodeSelector => io.k8s.api.core.v1.NodeSelector) : AllocationResult = copy(availableOnNodes = availableOnNodes.map(f))

  /** Returns a new data with resourceHandles set to new value */
  def withResourceHandles(value: Seq[io.k8s.api.resource.v1alpha2.ResourceHandle]) : AllocationResult = copy(resourceHandles = Some(value))
  /** Appends new values to resourceHandles */
  def addResourceHandles(newValues: io.k8s.api.resource.v1alpha2.ResourceHandle*) : AllocationResult = copy(resourceHandles = Some(resourceHandles.fold(newValues)(_ ++ newValues)))
  /** if resourceHandles has a value, transforms to the result of function*/
  def mapResourceHandles(f: Seq[io.k8s.api.resource.v1alpha2.ResourceHandle] => Seq[io.k8s.api.resource.v1alpha2.ResourceHandle]) : AllocationResult = copy(resourceHandles = resourceHandles.map(f))

  /** Returns a new data with shareable set to new value */
  def withShareable(value: Boolean) : AllocationResult = copy(shareable = Some(value))
  /** if shareable has a value, transforms to the result of function*/
  def mapShareable(f: Boolean => Boolean) : AllocationResult = copy(shareable = shareable.map(f))
}

object AllocationResult {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.AllocationResult] = new Encoder[io.k8s.api.resource.v1alpha2.AllocationResult] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.AllocationResult) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("availableOnNodes", o.availableOnNodes)
            .write("resourceHandles", o.resourceHandles)
            .write("shareable", o.shareable)
            .build
        }
    }

    implicit val decoder: Decoder[AllocationResult] = new Decoder[AllocationResult] {
      def apply[T : Reader](t: T): Either[String, AllocationResult] = for {
          obj <- ObjectReader(t)
          availableOnNodes <- obj.readOpt[io.k8s.api.core.v1.NodeSelector]("availableOnNodes")
          resourceHandles <- obj.readOpt[Seq[io.k8s.api.resource.v1alpha2.ResourceHandle]]("resourceHandles")
          shareable <- obj.readOpt[Boolean]("shareable")
      } yield AllocationResult (
          availableOnNodes = availableOnNodes,
          resourceHandles = resourceHandles,
          shareable = shareable
        )
    }
}

