package io.k8s.apimachinery.pkg.apis.meta.v1


/** GroupVersion contains the "group/version" and "version" string of a version. It is made a struct to keep extensibility. */
final case class GroupVersionForDiscovery(
  groupVersion : String,
  version : String
) {

  /** Returns a new data with groupVersion set to new value */
  def withGroupVersion(value: String) : GroupVersionForDiscovery = copy(groupVersion = value)
  /** transforms groupVersion to result of function */
  def mapGroupVersion(f: String => String) : GroupVersionForDiscovery = copy(groupVersion = f(groupVersion))

  /** Returns a new data with version set to new value */
  def withVersion(value: String) : GroupVersionForDiscovery = copy(version = value)
  /** transforms version to result of function */
  def mapVersion(f: String => String) : GroupVersionForDiscovery = copy(version = f(version))
}

