package io.k8s.api.storage.v1


/** VolumeError captures an error encountered during a volume operation. */
final case class VolumeError(
  message : Option[String] = None,
  time : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None
) {

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : VolumeError = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : VolumeError = copy(message = message.map(f))

  /** Returns a new data with time set to new value */
  def withTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : VolumeError = copy(time = Some(value))
  /** if time has a value, transforms to the result of function*/
  def mapTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : VolumeError = copy(time = time.map(f))
}

