package io.k8s.api.flowcontrol.v1beta2


/** PriorityLevelConfigurationStatus represents the current state of a "request-priority". */
final case class PriorityLevelConfigurationStatus(
  conditions : Option[Seq[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationCondition]] = None
) {

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationCondition]) : PriorityLevelConfigurationStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationCondition*) : PriorityLevelConfigurationStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationCondition] => Seq[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationCondition]) : PriorityLevelConfigurationStatus = copy(conditions = conditions.map(f))
}

