package io.k8s.api.flowcontrol.v1beta2

import dev.hnaderi.k8s._

/** FlowSchema defines the schema of a group of flows. Note that a flow is made up of a set of inbound API requests with similar attributes and is identified by a pair of strings: the name of the FlowSchema and a "flow distinguisher". */
final case class FlowSchema(
  status : Option[io.k8s.api.flowcontrol.v1beta2.FlowSchemaStatus] = None,
  spec : Option[io.k8s.api.flowcontrol.v1beta2.FlowSchemaSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("flowcontrol.apiserver.k8s.io", "FlowSchema", "v1beta2")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.flowcontrol.v1beta2.FlowSchemaStatus) : FlowSchema = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.flowcontrol.v1beta2.FlowSchemaStatus => io.k8s.api.flowcontrol.v1beta2.FlowSchemaStatus) : FlowSchema = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.flowcontrol.v1beta2.FlowSchemaSpec) : FlowSchema = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.flowcontrol.v1beta2.FlowSchemaSpec => io.k8s.api.flowcontrol.v1beta2.FlowSchemaSpec) : FlowSchema = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : FlowSchema = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : FlowSchema = copy(metadata = metadata.map(f))
}

