package io.k8s.api.core.v1


/** SessionAffinityConfig represents the configurations of session affinity. */
final case class SessionAffinityConfig(
  clientIP : Option[io.k8s.api.core.v1.ClientIPConfig] = None
) {

  /** Returns a new data with clientIP set to new value */
  def withClientIP(value: io.k8s.api.core.v1.ClientIPConfig) : SessionAffinityConfig = copy(clientIP = Some(value))
  /** if clientIP has a value, transforms to the result of function*/
  def mapClientIP(f: io.k8s.api.core.v1.ClientIPConfig => io.k8s.api.core.v1.ClientIPConfig) : SessionAffinityConfig = copy(clientIP = clientIP.map(f))
}

