package io.k8s.api.core.v1


/** ResourceQuotaStatus defines the enforced hard limits and observed use. */
final case class ResourceQuotaStatus(
  hard : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  used : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None
) {

  /** Returns a new data with hard set to new value */
  def withHard(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : ResourceQuotaStatus = copy(hard = Some(value))
  /** Adds new values to hard */
  def addHard(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : ResourceQuotaStatus = copy(hard = Some(hard.fold(newValues.toMap)(_ ++ newValues)))
  /** if hard has a value, transforms to the result of function*/
  def mapHard(f: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity] => Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : ResourceQuotaStatus = copy(hard = hard.map(f))

  /** Returns a new data with used set to new value */
  def withUsed(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : ResourceQuotaStatus = copy(used = Some(value))
  /** Adds new values to used */
  def addUsed(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : ResourceQuotaStatus = copy(used = Some(used.fold(newValues.toMap)(_ ++ newValues)))
  /** if used has a value, transforms to the result of function*/
  def mapUsed(f: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity] => Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : ResourceQuotaStatus = copy(used = used.map(f))
}

