package io.k8s.api.core.v1


/** PodDNSConfigOption defines DNS resolver options of a pod. */
final case class PodDNSConfigOption(
  name : Option[String] = None,
  value : Option[String] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : PodDNSConfigOption = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : PodDNSConfigOption = copy(name = name.map(f))

  /** Returns a new data with value set to new value */
  def withValue(value: String) : PodDNSConfigOption = copy(value = Some(value))
  /** if value has a value, transforms to the result of function*/
  def mapValue(f: String => String) : PodDNSConfigOption = copy(value = value.map(f))
}

