package io.k8s.api.core.v1


/** PersistentVolumeStatus is the current status of a persistent volume. */
final case class PersistentVolumeStatus(
  message : Option[String] = None,
  phase : Option[String] = None,
  reason : Option[String] = None
) {

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : PersistentVolumeStatus = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : PersistentVolumeStatus = copy(message = message.map(f))

  /** Returns a new data with phase set to new value */
  def withPhase(value: String) : PersistentVolumeStatus = copy(phase = Some(value))
  /** if phase has a value, transforms to the result of function*/
  def mapPhase(f: String => String) : PersistentVolumeStatus = copy(phase = phase.map(f))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : PersistentVolumeStatus = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : PersistentVolumeStatus = copy(reason = reason.map(f))
}

