package io.k8s.api.core.v1


/** NodeDaemonEndpoints lists ports opened by daemons running on the Node. */
final case class NodeDaemonEndpoints(
  kubeletEndpoint : Option[io.k8s.api.core.v1.DaemonEndpoint] = None
) {

  /** Returns a new data with kubeletEndpoint set to new value */
  def withKubeletEndpoint(value: io.k8s.api.core.v1.DaemonEndpoint) : NodeDaemonEndpoints = copy(kubeletEndpoint = Some(value))
  /** if kubeletEndpoint has a value, transforms to the result of function*/
  def mapKubeletEndpoint(f: io.k8s.api.core.v1.DaemonEndpoint => io.k8s.api.core.v1.DaemonEndpoint) : NodeDaemonEndpoints = copy(kubeletEndpoint = kubeletEndpoint.map(f))
}

