package io.k8s.api.core.v1


/** Node affinity is a group of node affinity scheduling rules. */
final case class NodeAffinity(
  preferredDuringSchedulingIgnoredDuringExecution : Option[Seq[io.k8s.api.core.v1.PreferredSchedulingTerm]] = None,
  requiredDuringSchedulingIgnoredDuringExecution : Option[io.k8s.api.core.v1.NodeSelector] = None
) {

  /** Returns a new data with preferredDuringSchedulingIgnoredDuringExecution set to new value */
  def withPreferredDuringSchedulingIgnoredDuringExecution(value: Seq[io.k8s.api.core.v1.PreferredSchedulingTerm]) : NodeAffinity = copy(preferredDuringSchedulingIgnoredDuringExecution = Some(value))
  /** Appends new values to preferredDuringSchedulingIgnoredDuringExecution */
  def addPreferredDuringSchedulingIgnoredDuringExecution(newValues: io.k8s.api.core.v1.PreferredSchedulingTerm*) : NodeAffinity = copy(preferredDuringSchedulingIgnoredDuringExecution = Some(preferredDuringSchedulingIgnoredDuringExecution.fold(newValues)(_ ++ newValues)))
  /** if preferredDuringSchedulingIgnoredDuringExecution has a value, transforms to the result of function*/
  def mapPreferredDuringSchedulingIgnoredDuringExecution(f: Seq[io.k8s.api.core.v1.PreferredSchedulingTerm] => Seq[io.k8s.api.core.v1.PreferredSchedulingTerm]) : NodeAffinity = copy(preferredDuringSchedulingIgnoredDuringExecution = preferredDuringSchedulingIgnoredDuringExecution.map(f))

  /** Returns a new data with requiredDuringSchedulingIgnoredDuringExecution set to new value */
  def withRequiredDuringSchedulingIgnoredDuringExecution(value: io.k8s.api.core.v1.NodeSelector) : NodeAffinity = copy(requiredDuringSchedulingIgnoredDuringExecution = Some(value))
  /** if requiredDuringSchedulingIgnoredDuringExecution has a value, transforms to the result of function*/
  def mapRequiredDuringSchedulingIgnoredDuringExecution(f: io.k8s.api.core.v1.NodeSelector => io.k8s.api.core.v1.NodeSelector) : NodeAffinity = copy(requiredDuringSchedulingIgnoredDuringExecution = requiredDuringSchedulingIgnoredDuringExecution.map(f))
}

