package io.k8s.api.core.v1


/** HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file. */
final case class HostAlias(
  hostnames : Option[Seq[String]] = None,
  ip : Option[String] = None
) {

  /** Returns a new data with hostnames set to new value */
  def withHostnames(value: Seq[String]) : HostAlias = copy(hostnames = Some(value))
  /** Appends new values to hostnames */
  def addHostnames(newValues: String*) : HostAlias = copy(hostnames = Some(hostnames.fold(newValues)(_ ++ newValues)))
  /** if hostnames has a value, transforms to the result of function*/
  def mapHostnames(f: Seq[String] => Seq[String]) : HostAlias = copy(hostnames = hostnames.map(f))

  /** Returns a new data with ip set to new value */
  def withIp(value: String) : HostAlias = copy(ip = Some(value))
  /** if ip has a value, transforms to the result of function*/
  def mapIp(f: String => String) : HostAlias = copy(ip = ip.map(f))
}

