package io.k8s.api.core.v1


/** Selects a key from a ConfigMap. */
final case class ConfigMapKeySelector(
  key : String,
  name : Option[String] = None,
  optional : Option[Boolean] = None
) {

  /** Returns a new data with key set to new value */
  def withKey(value: String) : ConfigMapKeySelector = copy(key = value)
  /** transforms key to result of function */
  def mapKey(f: String => String) : ConfigMapKeySelector = copy(key = f(key))

  /** Returns a new data with name set to new value */
  def withName(value: String) : ConfigMapKeySelector = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : ConfigMapKeySelector = copy(name = name.map(f))

  /** Returns a new data with optional set to new value */
  def withOptional(value: Boolean) : ConfigMapKeySelector = copy(optional = Some(value))
  /** if optional has a value, transforms to the result of function*/
  def mapOptional(f: Boolean => Boolean) : ConfigMapKeySelector = copy(optional = optional.map(f))
}

