package io.k8s.api.core.v1


/** AzureFile represents an Azure File Service mount on the host and bind mount to the pod. */
final case class AzureFilePersistentVolumeSource(
  secretName : String,
  shareName : String,
  readOnly : Option[Boolean] = None,
  secretNamespace : Option[String] = None
) {

  /** Returns a new data with secretName set to new value */
  def withSecretName(value: String) : AzureFilePersistentVolumeSource = copy(secretName = value)
  /** transforms secretName to result of function */
  def mapSecretName(f: String => String) : AzureFilePersistentVolumeSource = copy(secretName = f(secretName))

  /** Returns a new data with shareName set to new value */
  def withShareName(value: String) : AzureFilePersistentVolumeSource = copy(shareName = value)
  /** transforms shareName to result of function */
  def mapShareName(f: String => String) : AzureFilePersistentVolumeSource = copy(shareName = f(shareName))

  /** Returns a new data with readOnly set to new value */
  def withReadOnly(value: Boolean) : AzureFilePersistentVolumeSource = copy(readOnly = Some(value))
  /** if readOnly has a value, transforms to the result of function*/
  def mapReadOnly(f: Boolean => Boolean) : AzureFilePersistentVolumeSource = copy(readOnly = readOnly.map(f))

  /** Returns a new data with secretNamespace set to new value */
  def withSecretNamespace(value: String) : AzureFilePersistentVolumeSource = copy(secretNamespace = Some(value))
  /** if secretNamespace has a value, transforms to the result of function*/
  def mapSecretNamespace(f: String => String) : AzureFilePersistentVolumeSource = copy(secretNamespace = secretNamespace.map(f))
}

