package io.k8s.api.autoscaling.v1


/** ScaleSpec describes the attributes of a scale subresource. */
final case class ScaleSpec(
  replicas : Option[Int] = None
) {

  /** Returns a new data with replicas set to new value */
  def withReplicas(value: Int) : ScaleSpec = copy(replicas = Some(value))
  /** if replicas has a value, transforms to the result of function*/
  def mapReplicas(f: Int => Int) : ScaleSpec = copy(replicas = replicas.map(f))
}

