package io.k8s.api.authorization.v1


/** NonResourceAttributes includes the authorization attributes available for non-resource requests to the Authorizer interface */
final case class NonResourceAttributes(
  path : Option[String] = None,
  verb : Option[String] = None
) {

  /** Returns a new data with path set to new value */
  def withPath(value: String) : NonResourceAttributes = copy(path = Some(value))
  /** if path has a value, transforms to the result of function*/
  def mapPath(f: String => String) : NonResourceAttributes = copy(path = path.map(f))

  /** Returns a new data with verb set to new value */
  def withVerb(value: String) : NonResourceAttributes = copy(verb = Some(value))
  /** if verb has a value, transforms to the result of function*/
  def mapVerb(f: String => String) : NonResourceAttributes = copy(verb = verb.map(f))
}

