package io.k8s.api.authentication.v1


/** TokenRequestSpec contains client provided parameters of a token request. */
final case class TokenRequestSpec(
  audiences : Seq[String],
  boundObjectRef : Option[io.k8s.api.authentication.v1.BoundObjectReference] = None,
  expirationSeconds : Option[Int] = None
) {

  /** Returns a new data with audiences set to new value */
  def withAudiences(value: Seq[String]) : TokenRequestSpec = copy(audiences = value)
  /** Appends new values to audiences */
  def addAudiences(newValues: String*) : TokenRequestSpec = copy(audiences = audiences ++ newValues)
  /** transforms audiences to result of function */
  def mapAudiences(f: Seq[String] => Seq[String]) : TokenRequestSpec = copy(audiences = f(audiences))

  /** Returns a new data with boundObjectRef set to new value */
  def withBoundObjectRef(value: io.k8s.api.authentication.v1.BoundObjectReference) : TokenRequestSpec = copy(boundObjectRef = Some(value))
  /** if boundObjectRef has a value, transforms to the result of function*/
  def mapBoundObjectRef(f: io.k8s.api.authentication.v1.BoundObjectReference => io.k8s.api.authentication.v1.BoundObjectReference) : TokenRequestSpec = copy(boundObjectRef = boundObjectRef.map(f))

  /** Returns a new data with expirationSeconds set to new value */
  def withExpirationSeconds(value: Int) : TokenRequestSpec = copy(expirationSeconds = Some(value))
  /** if expirationSeconds has a value, transforms to the result of function*/
  def mapExpirationSeconds(f: Int => Int) : TokenRequestSpec = copy(expirationSeconds = expirationSeconds.map(f))
}

