package io.k8s.api.resource.v1alpha1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ResourceClaimTemplate is used to produce ResourceClaim objects. */
final case class ResourceClaimTemplate(
  spec : io.k8s.api.resource.v1alpha1.ResourceClaimTemplateSpec,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("resource.k8s.io", "ResourceClaimTemplate", "v1alpha1")


  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.resource.v1alpha1.ResourceClaimTemplateSpec) : ResourceClaimTemplate = copy(spec = value)
  /** transforms spec to result of function */
  def mapSpec(f: io.k8s.api.resource.v1alpha1.ResourceClaimTemplateSpec => io.k8s.api.resource.v1alpha1.ResourceClaimTemplateSpec) : ResourceClaimTemplate = copy(spec = f(spec))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ResourceClaimTemplate = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ResourceClaimTemplate = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ResourceClaimTemplate.encoder.apply(this)
}

object ResourceClaimTemplate {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha1.ResourceClaimTemplate] = new Encoder[io.k8s.api.resource.v1alpha1.ResourceClaimTemplate] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha1.ResourceClaimTemplate) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceClaimTemplate] = new Decoder[ResourceClaimTemplate] {
      def apply[T : Reader](t: T): Either[String, ResourceClaimTemplate] = for {
          obj <- ObjectReader(t)
          spec <- obj.read[io.k8s.api.resource.v1alpha1.ResourceClaimTemplateSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield ResourceClaimTemplate (
          spec = spec,
          metadata = metadata
        )
    }
}

