package io.k8s.api.resource.v1alpha1

import dev.hnaderi.k8s.utils._

/** ResourceClaimSpec defines how a resource is to be allocated. */
final case class ResourceClaimSpec(
  resourceClassName : String,
  allocationMode : Option[String] = None,
  parametersRef : Option[io.k8s.api.resource.v1alpha1.ResourceClaimParametersReference] = None
) {

  /** Returns a new data with resourceClassName set to new value */
  def withResourceClassName(value: String) : ResourceClaimSpec = copy(resourceClassName = value)
  /** transforms resourceClassName to result of function */
  def mapResourceClassName(f: String => String) : ResourceClaimSpec = copy(resourceClassName = f(resourceClassName))

  /** Returns a new data with allocationMode set to new value */
  def withAllocationMode(value: String) : ResourceClaimSpec = copy(allocationMode = Some(value))
  /** if allocationMode has a value, transforms to the result of function*/
  def mapAllocationMode(f: String => String) : ResourceClaimSpec = copy(allocationMode = allocationMode.map(f))

  /** Returns a new data with parametersRef set to new value */
  def withParametersRef(value: io.k8s.api.resource.v1alpha1.ResourceClaimParametersReference) : ResourceClaimSpec = copy(parametersRef = Some(value))
  /** if parametersRef has a value, transforms to the result of function*/
  def mapParametersRef(f: io.k8s.api.resource.v1alpha1.ResourceClaimParametersReference => io.k8s.api.resource.v1alpha1.ResourceClaimParametersReference) : ResourceClaimSpec = copy(parametersRef = parametersRef.map(f))
}

object ResourceClaimSpec {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha1.ResourceClaimSpec] = new Encoder[io.k8s.api.resource.v1alpha1.ResourceClaimSpec] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha1.ResourceClaimSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("resourceClassName", o.resourceClassName)
            .write("allocationMode", o.allocationMode)
            .write("parametersRef", o.parametersRef)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceClaimSpec] = new Decoder[ResourceClaimSpec] {
      def apply[T : Reader](t: T): Either[String, ResourceClaimSpec] = for {
          obj <- ObjectReader(t)
          resourceClassName <- obj.read[String]("resourceClassName")
          allocationMode <- obj.readOpt[String]("allocationMode")
          parametersRef <- obj.readOpt[io.k8s.api.resource.v1alpha1.ResourceClaimParametersReference]("parametersRef")
      } yield ResourceClaimSpec (
          resourceClassName = resourceClassName,
          allocationMode = allocationMode,
          parametersRef = parametersRef
        )
    }
}

