package io.k8s.api.flowcontrol.v1beta1

import dev.hnaderi.k8s.utils._

/** UserSubject holds detailed information for user-kind subject. */
final case class UserSubject(
  name : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : UserSubject = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : UserSubject = copy(name = f(name))
}

object UserSubject {

    implicit val encoder : Encoder[io.k8s.api.flowcontrol.v1beta1.UserSubject] = new Encoder[io.k8s.api.flowcontrol.v1beta1.UserSubject] {
        def apply[T : Builder](o: io.k8s.api.flowcontrol.v1beta1.UserSubject) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .build
        }
    }

    implicit val decoder: Decoder[UserSubject] = new Decoder[UserSubject] {
      def apply[T : Reader](t: T): Either[String, UserSubject] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
      } yield UserSubject (
          name = name
        )
    }
}

