package io.k8s.api.networking.v1alpha1

import dev.hnaderi.k8s.utils._

/** ServiceCIDRSpec define the CIDRs the user wants to use for allocating ClusterIPs for Services. */
final case class ServiceCIDRSpec(
  cidrs : Option[Seq[String]] = None
) {

  /** Returns a new data with cidrs set to new value */
  def withCidrs(value: Seq[String]) : ServiceCIDRSpec = copy(cidrs = Some(value))
  /** Appends new values to cidrs */
  def addCidrs(newValues: String*) : ServiceCIDRSpec = copy(cidrs = Some(cidrs.fold(newValues)(_ ++ newValues)))
  /** if cidrs has a value, transforms to the result of function*/
  def mapCidrs(f: Seq[String] => Seq[String]) : ServiceCIDRSpec = copy(cidrs = cidrs.map(f))
}

object ServiceCIDRSpec {

    implicit val encoder : Encoder[io.k8s.api.networking.v1alpha1.ServiceCIDRSpec] = new Encoder[io.k8s.api.networking.v1alpha1.ServiceCIDRSpec] {
        def apply[T : Builder](o: io.k8s.api.networking.v1alpha1.ServiceCIDRSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("cidrs", o.cidrs)
            .build
        }
    }

    implicit val decoder: Decoder[ServiceCIDRSpec] = new Decoder[ServiceCIDRSpec] {
      def apply[T : Reader](t: T): Either[String, ServiceCIDRSpec] = for {
          obj <- ObjectReader(t)
          cidrs <- obj.readOpt[Seq[String]]("cidrs")
      } yield ServiceCIDRSpec (
          cidrs = cidrs
        )
    }
}

