package io.k8s.api.flowcontrol.v1

import dev.hnaderi.k8s.utils._

/** PriorityLevelConfigurationSpec specifies the configuration of a priority level. */
final case class PriorityLevelConfigurationSpec(
  `type` : String,
  exempt : Option[io.k8s.api.flowcontrol.v1.ExemptPriorityLevelConfiguration] = None,
  limited : Option[io.k8s.api.flowcontrol.v1.LimitedPriorityLevelConfiguration] = None
) {

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : PriorityLevelConfigurationSpec = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : PriorityLevelConfigurationSpec = copy(`type` = f(`type`))

  /** Returns a new data with exempt set to new value */
  def withExempt(value: io.k8s.api.flowcontrol.v1.ExemptPriorityLevelConfiguration) : PriorityLevelConfigurationSpec = copy(exempt = Some(value))
  /** if exempt has a value, transforms to the result of function*/
  def mapExempt(f: io.k8s.api.flowcontrol.v1.ExemptPriorityLevelConfiguration => io.k8s.api.flowcontrol.v1.ExemptPriorityLevelConfiguration) : PriorityLevelConfigurationSpec = copy(exempt = exempt.map(f))

  /** Returns a new data with limited set to new value */
  def withLimited(value: io.k8s.api.flowcontrol.v1.LimitedPriorityLevelConfiguration) : PriorityLevelConfigurationSpec = copy(limited = Some(value))
  /** if limited has a value, transforms to the result of function*/
  def mapLimited(f: io.k8s.api.flowcontrol.v1.LimitedPriorityLevelConfiguration => io.k8s.api.flowcontrol.v1.LimitedPriorityLevelConfiguration) : PriorityLevelConfigurationSpec = copy(limited = limited.map(f))
}

object PriorityLevelConfigurationSpec {

    implicit val encoder : Encoder[io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationSpec] = new Encoder[io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationSpec] {
        def apply[T : Builder](o: io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("type", o.`type`)
            .write("exempt", o.exempt)
            .write("limited", o.limited)
            .build
        }
    }

    implicit val decoder: Decoder[PriorityLevelConfigurationSpec] = new Decoder[PriorityLevelConfigurationSpec] {
      def apply[T : Reader](t: T): Either[String, PriorityLevelConfigurationSpec] = for {
          obj <- ObjectReader(t)
          `type` <- obj.read[String]("type")
          exempt <- obj.readOpt[io.k8s.api.flowcontrol.v1.ExemptPriorityLevelConfiguration]("exempt")
          limited <- obj.readOpt[io.k8s.api.flowcontrol.v1.LimitedPriorityLevelConfiguration]("limited")
      } yield PriorityLevelConfigurationSpec (
          `type` = `type`,
          exempt = exempt,
          limited = limited
        )
    }
}

