package io.k8s.api.networking.v1alpha1

import dev.hnaderi.k8s.utils._

/** IPAddressSpec describe the attributes in an IP Address. */
final case class IPAddressSpec(
  parentRef : Option[io.k8s.api.networking.v1alpha1.ParentReference] = None
) {

  /** Returns a new data with parentRef set to new value */
  def withParentRef(value: io.k8s.api.networking.v1alpha1.ParentReference) : IPAddressSpec = copy(parentRef = Some(value))
  /** if parentRef has a value, transforms to the result of function*/
  def mapParentRef(f: io.k8s.api.networking.v1alpha1.ParentReference => io.k8s.api.networking.v1alpha1.ParentReference) : IPAddressSpec = copy(parentRef = parentRef.map(f))
}

object IPAddressSpec {

    implicit val encoder : Encoder[io.k8s.api.networking.v1alpha1.IPAddressSpec] = new Encoder[io.k8s.api.networking.v1alpha1.IPAddressSpec] {
        def apply[T : Builder](o: io.k8s.api.networking.v1alpha1.IPAddressSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("parentRef", o.parentRef)
            .build
        }
    }

    implicit val decoder: Decoder[IPAddressSpec] = new Decoder[IPAddressSpec] {
      def apply[T : Reader](t: T): Either[String, IPAddressSpec] = for {
          obj <- ObjectReader(t)
          parentRef <- obj.readOpt[io.k8s.api.networking.v1alpha1.ParentReference]("parentRef")
      } yield IPAddressSpec (
          parentRef = parentRef
        )
    }
}

