package io.k8s.api.authentication.v1

import dev.hnaderi.k8s.utils._

/** SelfSubjectReviewStatus is filled by the kube-apiserver and sent back to a user. */
final case class SelfSubjectReviewStatus(
  userInfo : Option[io.k8s.api.authentication.v1.UserInfo] = None
) {

  /** Returns a new data with userInfo set to new value */
  def withUserInfo(value: io.k8s.api.authentication.v1.UserInfo) : SelfSubjectReviewStatus = copy(userInfo = Some(value))
  /** if userInfo has a value, transforms to the result of function*/
  def mapUserInfo(f: io.k8s.api.authentication.v1.UserInfo => io.k8s.api.authentication.v1.UserInfo) : SelfSubjectReviewStatus = copy(userInfo = userInfo.map(f))
}

object SelfSubjectReviewStatus {

    implicit val encoder : Encoder[io.k8s.api.authentication.v1.SelfSubjectReviewStatus] = new Encoder[io.k8s.api.authentication.v1.SelfSubjectReviewStatus] {
        def apply[T : Builder](o: io.k8s.api.authentication.v1.SelfSubjectReviewStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("userInfo", o.userInfo)
            .build
        }
    }

    implicit val decoder: Decoder[SelfSubjectReviewStatus] = new Decoder[SelfSubjectReviewStatus] {
      def apply[T : Reader](t: T): Either[String, SelfSubjectReviewStatus] = for {
          obj <- ObjectReader(t)
          userInfo <- obj.readOpt[io.k8s.api.authentication.v1.UserInfo]("userInfo")
      } yield SelfSubjectReviewStatus (
          userInfo = userInfo
        )
    }
}

