package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ResourceClaimTemplateList is a collection of claim templates. */
final case class ResourceClaimTemplateList(
  items : Seq[io.k8s.api.resource.v1alpha2.ResourceClaimTemplate],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("resource.k8s.io", "ResourceClaimTemplateList", "v1alpha2")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.resource.v1alpha2.ResourceClaimTemplate]) : ResourceClaimTemplateList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.resource.v1alpha2.ResourceClaimTemplate*) : ResourceClaimTemplateList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.resource.v1alpha2.ResourceClaimTemplate] => Seq[io.k8s.api.resource.v1alpha2.ResourceClaimTemplate]) : ResourceClaimTemplateList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ResourceClaimTemplateList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ResourceClaimTemplateList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ResourceClaimTemplateList.encoder.apply(this)
}

object ResourceClaimTemplateList {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.ResourceClaimTemplateList] = new Encoder[io.k8s.api.resource.v1alpha2.ResourceClaimTemplateList] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.ResourceClaimTemplateList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceClaimTemplateList] = new Decoder[ResourceClaimTemplateList] {
      def apply[T : Reader](t: T): Either[String, ResourceClaimTemplateList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.resource.v1alpha2.ResourceClaimTemplate]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield ResourceClaimTemplateList (
          items = items,
          metadata = metadata
        )
    }
}

