package io.k8s.api.authentication.v1

import dev.hnaderi.k8s.utils._

/** TokenRequestStatus is the result of a token request. */
final case class TokenRequestStatus(
  expirationTimestamp : io.k8s.apimachinery.pkg.apis.meta.v1.Time,
  token : String
) {

  /** Returns a new data with expirationTimestamp set to new value */
  def withExpirationTimestamp(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : TokenRequestStatus = copy(expirationTimestamp = value)
  /** transforms expirationTimestamp to result of function */
  def mapExpirationTimestamp(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : TokenRequestStatus = copy(expirationTimestamp = f(expirationTimestamp))

  /** Returns a new data with token set to new value */
  def withToken(value: String) : TokenRequestStatus = copy(token = value)
  /** transforms token to result of function */
  def mapToken(f: String => String) : TokenRequestStatus = copy(token = f(token))
}

object TokenRequestStatus {

    implicit val encoder : Encoder[io.k8s.api.authentication.v1.TokenRequestStatus] = new Encoder[io.k8s.api.authentication.v1.TokenRequestStatus] {
        def apply[T : Builder](o: io.k8s.api.authentication.v1.TokenRequestStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("expirationTimestamp", o.expirationTimestamp)
            .write("token", o.token)
            .build
        }
    }

    implicit val decoder: Decoder[TokenRequestStatus] = new Decoder[TokenRequestStatus] {
      def apply[T : Reader](t: T): Either[String, TokenRequestStatus] = for {
          obj <- ObjectReader(t)
          expirationTimestamp <- obj.read[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("expirationTimestamp")
          token <- obj.read[String]("token")
      } yield TokenRequestStatus (
          expirationTimestamp = expirationTimestamp,
          token = token
        )
    }
}

