package io.k8s.api.flowcontrol.v1beta2

import dev.hnaderi.k8s.utils._

/** PolicyRulesWithSubjects prescribes a test that applies to a request to an apiserver. The test considers the subject making the request, the verb being requested, and the resource to be acted upon. This PolicyRulesWithSubjects matches a request if and only if both (a) at least one member of subjects matches the request and (b) at least one member of resourceRules or nonResourceRules matches the request. */
final case class PolicyRulesWithSubjects(
  subjects : Seq[io.k8s.api.flowcontrol.v1beta2.Subject],
  nonResourceRules : Option[Seq[io.k8s.api.flowcontrol.v1beta2.NonResourcePolicyRule]] = None,
  resourceRules : Option[Seq[io.k8s.api.flowcontrol.v1beta2.ResourcePolicyRule]] = None
) {

  /** Returns a new data with subjects set to new value */
  def withSubjects(value: Seq[io.k8s.api.flowcontrol.v1beta2.Subject]) : PolicyRulesWithSubjects = copy(subjects = value)
  /** Appends new values to subjects */
  def addSubjects(newValues: io.k8s.api.flowcontrol.v1beta2.Subject*) : PolicyRulesWithSubjects = copy(subjects = subjects ++ newValues)
  /** transforms subjects to result of function */
  def mapSubjects(f: Seq[io.k8s.api.flowcontrol.v1beta2.Subject] => Seq[io.k8s.api.flowcontrol.v1beta2.Subject]) : PolicyRulesWithSubjects = copy(subjects = f(subjects))

  /** Returns a new data with nonResourceRules set to new value */
  def withNonResourceRules(value: Seq[io.k8s.api.flowcontrol.v1beta2.NonResourcePolicyRule]) : PolicyRulesWithSubjects = copy(nonResourceRules = Some(value))
  /** Appends new values to nonResourceRules */
  def addNonResourceRules(newValues: io.k8s.api.flowcontrol.v1beta2.NonResourcePolicyRule*) : PolicyRulesWithSubjects = copy(nonResourceRules = Some(nonResourceRules.fold(newValues)(_ ++ newValues)))
  /** if nonResourceRules has a value, transforms to the result of function*/
  def mapNonResourceRules(f: Seq[io.k8s.api.flowcontrol.v1beta2.NonResourcePolicyRule] => Seq[io.k8s.api.flowcontrol.v1beta2.NonResourcePolicyRule]) : PolicyRulesWithSubjects = copy(nonResourceRules = nonResourceRules.map(f))

  /** Returns a new data with resourceRules set to new value */
  def withResourceRules(value: Seq[io.k8s.api.flowcontrol.v1beta2.ResourcePolicyRule]) : PolicyRulesWithSubjects = copy(resourceRules = Some(value))
  /** Appends new values to resourceRules */
  def addResourceRules(newValues: io.k8s.api.flowcontrol.v1beta2.ResourcePolicyRule*) : PolicyRulesWithSubjects = copy(resourceRules = Some(resourceRules.fold(newValues)(_ ++ newValues)))
  /** if resourceRules has a value, transforms to the result of function*/
  def mapResourceRules(f: Seq[io.k8s.api.flowcontrol.v1beta2.ResourcePolicyRule] => Seq[io.k8s.api.flowcontrol.v1beta2.ResourcePolicyRule]) : PolicyRulesWithSubjects = copy(resourceRules = resourceRules.map(f))
}

object PolicyRulesWithSubjects {

    implicit val encoder : Encoder[io.k8s.api.flowcontrol.v1beta2.PolicyRulesWithSubjects] = new Encoder[io.k8s.api.flowcontrol.v1beta2.PolicyRulesWithSubjects] {
        def apply[T : Builder](o: io.k8s.api.flowcontrol.v1beta2.PolicyRulesWithSubjects) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("subjects", o.subjects)
            .write("nonResourceRules", o.nonResourceRules)
            .write("resourceRules", o.resourceRules)
            .build
        }
    }

    implicit val decoder: Decoder[PolicyRulesWithSubjects] = new Decoder[PolicyRulesWithSubjects] {
      def apply[T : Reader](t: T): Either[String, PolicyRulesWithSubjects] = for {
          obj <- ObjectReader(t)
          subjects <- obj.read[Seq[io.k8s.api.flowcontrol.v1beta2.Subject]]("subjects")
          nonResourceRules <- obj.readOpt[Seq[io.k8s.api.flowcontrol.v1beta2.NonResourcePolicyRule]]("nonResourceRules")
          resourceRules <- obj.readOpt[Seq[io.k8s.api.flowcontrol.v1beta2.ResourcePolicyRule]]("resourceRules")
      } yield PolicyRulesWithSubjects (
          subjects = subjects,
          nonResourceRules = nonResourceRules,
          resourceRules = resourceRules
        )
    }
}

