package io.k8s.api.resource.v1alpha1

import dev.hnaderi.k8s.utils._

/** AllocationResult contains attributed of an allocated resource. */
final case class AllocationResult(
  availableOnNodes : Option[io.k8s.api.core.v1.NodeSelector] = None,
  resourceHandle : Option[String] = None,
  shareable : Option[Boolean] = None
) {

  /** Returns a new data with availableOnNodes set to new value */
  def withAvailableOnNodes(value: io.k8s.api.core.v1.NodeSelector) : AllocationResult = copy(availableOnNodes = Some(value))
  /** if availableOnNodes has a value, transforms to the result of function*/
  def mapAvailableOnNodes(f: io.k8s.api.core.v1.NodeSelector => io.k8s.api.core.v1.NodeSelector) : AllocationResult = copy(availableOnNodes = availableOnNodes.map(f))

  /** Returns a new data with resourceHandle set to new value */
  def withResourceHandle(value: String) : AllocationResult = copy(resourceHandle = Some(value))
  /** if resourceHandle has a value, transforms to the result of function*/
  def mapResourceHandle(f: String => String) : AllocationResult = copy(resourceHandle = resourceHandle.map(f))

  /** Returns a new data with shareable set to new value */
  def withShareable(value: Boolean) : AllocationResult = copy(shareable = Some(value))
  /** if shareable has a value, transforms to the result of function*/
  def mapShareable(f: Boolean => Boolean) : AllocationResult = copy(shareable = shareable.map(f))
}

object AllocationResult {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha1.AllocationResult] = new Encoder[io.k8s.api.resource.v1alpha1.AllocationResult] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha1.AllocationResult) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("availableOnNodes", o.availableOnNodes)
            .write("resourceHandle", o.resourceHandle)
            .write("shareable", o.shareable)
            .build
        }
    }

    implicit val decoder: Decoder[AllocationResult] = new Decoder[AllocationResult] {
      def apply[T : Reader](t: T): Either[String, AllocationResult] = for {
          obj <- ObjectReader(t)
          availableOnNodes <- obj.readOpt[io.k8s.api.core.v1.NodeSelector]("availableOnNodes")
          resourceHandle <- obj.readOpt[String]("resourceHandle")
          shareable <- obj.readOpt[Boolean]("shareable")
      } yield AllocationResult (
          availableOnNodes = availableOnNodes,
          resourceHandle = resourceHandle,
          shareable = shareable
        )
    }
}

