package io.k8s.api.networking.v1alpha1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ClusterCIDR represents a single configuration for per-Node Pod CIDR allocations when the MultiCIDRRangeAllocator is enabled (see the config for kube-controller-manager).  A cluster may have any number of ClusterCIDR resources, all of which will be considered when allocating a CIDR for a Node.  A ClusterCIDR is eligible to be used for a given Node when the node selector matches the node in question and has free CIDRs to allocate.  In case of multiple matching ClusterCIDR resources, the allocator will attempt to break ties using internal heuristics, but any ClusterCIDR whose node selector matches the Node may be used. */
final case class ClusterCIDR(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec : Option[io.k8s.api.networking.v1alpha1.ClusterCIDRSpec] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("networking.k8s.io", "ClusterCIDR", "v1alpha1")


  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ClusterCIDR = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ClusterCIDR = copy(metadata = metadata.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.networking.v1alpha1.ClusterCIDRSpec) : ClusterCIDR = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.networking.v1alpha1.ClusterCIDRSpec => io.k8s.api.networking.v1alpha1.ClusterCIDRSpec) : ClusterCIDR = copy(spec = spec.map(f))

  override def foldTo[T : Builder] : T = ClusterCIDR.encoder.apply(this)
}

object ClusterCIDR {

    implicit val encoder : Encoder[io.k8s.api.networking.v1alpha1.ClusterCIDR] = new Encoder[io.k8s.api.networking.v1alpha1.ClusterCIDR] {
        def apply[T : Builder](o: io.k8s.api.networking.v1alpha1.ClusterCIDR) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("metadata", o.metadata)
            .write("spec", o.spec)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ClusterCIDR] = new Decoder[ClusterCIDR] {
      def apply[T : Reader](t: T): Either[String, ClusterCIDR] = for {
          obj <- ObjectReader(t)
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
          spec <- obj.readOpt[io.k8s.api.networking.v1alpha1.ClusterCIDRSpec]("spec")
      } yield ClusterCIDR (
          metadata = metadata,
          spec = spec
        )
    }
}

