package io.k8s.api.networking.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** IngressClass represents the class of the Ingress, referenced by the Ingress Spec. The `ingressclass.kubernetes.io/is-default-class` annotation can be used to indicate that an IngressClass should be considered default. When a single IngressClass resource has this annotation set to true, new Ingress resources without a class specified will be assigned this default class. */
final case class IngressClass(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec : Option[io.k8s.api.networking.v1.IngressClassSpec] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("networking.k8s.io", "IngressClass", "v1")


  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : IngressClass = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : IngressClass = copy(metadata = metadata.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.networking.v1.IngressClassSpec) : IngressClass = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.networking.v1.IngressClassSpec => io.k8s.api.networking.v1.IngressClassSpec) : IngressClass = copy(spec = spec.map(f))

  override def foldTo[T : Builder] : T = IngressClass.encoder.apply(this)
}

object IngressClass {

    implicit val encoder : Encoder[io.k8s.api.networking.v1.IngressClass] = new Encoder[io.k8s.api.networking.v1.IngressClass] {
        def apply[T : Builder](o: io.k8s.api.networking.v1.IngressClass) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("metadata", o.metadata)
            .write("spec", o.spec)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[IngressClass] = new Decoder[IngressClass] {
      def apply[T : Reader](t: T): Either[String, IngressClass] = for {
          obj <- ObjectReader(t)
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
          spec <- obj.readOpt[io.k8s.api.networking.v1.IngressClassSpec]("spec")
      } yield IngressClass (
          metadata = metadata,
          spec = spec
        )
    }
}

