package io.k8s.kube_aggregator.pkg.apis.apiregistration.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** APIService represents a server for a particular GroupVersion. Name must be "version.group". */
final case class APIService(
  status : Option[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceStatus] = None,
  spec : Option[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apiregistration.k8s.io", "APIService", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceStatus) : APIService = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceStatus => io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceStatus) : APIService = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceSpec) : APIService = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceSpec => io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceSpec) : APIService = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : APIService = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : APIService = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = APIService.encoder[T].apply(this)
}

object APIService {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIService, T] = new Encoder[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIService, T] {
        def apply(o: io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIService) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, APIService] = new Decoder[T, APIService] {
      def apply(t: T): Either[String, APIService] = for {
          obj <- ObjectReader(t)
          status <- obj.readOpt[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceStatus]("status")
          spec <- obj.readOpt[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield APIService (
          status = status,
          spec = spec,
          metadata = metadata
        )
    }
}

