package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** Status is a return value for calls that don't return other objects. */
final case class Status(
  reason : Option[String] = None,
  code : Option[Int] = None,
  status : Option[String] = None,
  details : Option[io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None,
  message : Option[String] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "Status", "v1")


  /** Returns a new data with reason set to new value */
  def withReason(value: String) : Status = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : Status = copy(reason = reason.map(f))

  /** Returns a new data with code set to new value */
  def withCode(value: Int) : Status = copy(code = Some(value))
  /** if code has a value, transforms to the result of function*/
  def mapCode(f: Int => Int) : Status = copy(code = code.map(f))

  /** Returns a new data with status set to new value */
  def withStatus(value: String) : Status = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: String => String) : Status = copy(status = status.map(f))

  /** Returns a new data with details set to new value */
  def withDetails(value: io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails) : Status = copy(details = Some(value))
  /** if details has a value, transforms to the result of function*/
  def mapDetails(f: io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails => io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails) : Status = copy(details = details.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : Status = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : Status = copy(metadata = metadata.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : Status = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : Status = copy(message = message.map(f))

  override def foldTo[T : Builder] : T = Status.encoder[T].apply(this)
}

object Status {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.Status, T] = new Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.Status, T] {
        def apply(o: io.k8s.apimachinery.pkg.apis.meta.v1.Status) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("reason", o.reason)
            .write("code", o.code)
            .write("status", o.status)
            .write("details", o.details)
            .write("metadata", o.metadata)
            .write("message", o.message)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, Status] = new Decoder[T, Status] {
      def apply(t: T): Either[String, Status] = for {
          obj <- ObjectReader(t)
          reason <- obj.readOpt[String]("reason")
          code <- obj.readOpt[Int]("code")
          status <- obj.readOpt[String]("status")
          details <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails]("details")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
          message <- obj.readOpt[String]("message")
      } yield Status (
          reason = reason,
          code = code,
          status = status,
          details = details,
          metadata = metadata,
          message = message
        )
    }
}

