package io.k8s.api.rbac.v1

import dev.hnaderi.k8s.utils._

/** RoleRef contains information that points to the role being used */
final case class RoleRef(
  apiGroup : String,
  name : String
) {

  /** Returns a new data with apiGroup set to new value */
  def withApiGroup(value: String) : RoleRef = copy(apiGroup = value)
  /** transforms apiGroup to result of function */
  def mapApiGroup(f: String => String) : RoleRef = copy(apiGroup = f(apiGroup))

  /** Returns a new data with name set to new value */
  def withName(value: String) : RoleRef = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : RoleRef = copy(name = f(name))
}

object RoleRef {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.rbac.v1.RoleRef, T] = new Encoder[io.k8s.api.rbac.v1.RoleRef, T] {
        def apply(o: io.k8s.api.rbac.v1.RoleRef) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("apiGroup", o.apiGroup)
            .write("name", o.name)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, RoleRef] = new Decoder[T, RoleRef] {
      def apply(t: T): Either[String, RoleRef] = for {
          obj <- ObjectReader(t)
          apiGroup <- obj.read[String]("apiGroup")
          name <- obj.read[String]("name")
      } yield RoleRef (
          apiGroup = apiGroup,
          name = name
        )
    }
}

